// This class uses the ObjTempParticles class to handle particles for a certain timeframe
/******************************************************************************/
class SpawnParticles : BaseEvent
{
public:
            SpawnParticles();
   virtual ~SpawnParticles();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   VarParticles* m_VarParticles;
   UID m_VarParticlesUID;
};
/******************************************************************************/
SpawnParticles::SpawnParticles() : BaseEvent(), m_VarParticles(null)             
{
   
}
SpawnParticles::~SpawnParticles()
{
   
}
/******************************************************************************/
void SpawnParticles::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarParticlesUID")) m_VarParticlesUID = p.asID();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SpawnParticles::AfterCreate()
{  
   // Find the correct VarInt to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesParticles)
      if(variablesParticles[i].id() == m_VarParticlesUID)
         m_VarParticles = &variablesParticles[i];
         
   DEBUG_ASSERT(m_VarParticles != null, "SpawnParticles: Particles var not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SpawnParticles::CallTriggeredAction()
{
   m_VarParticles->SetDraw(true);
}

// This method is called when the duration of the event has been reached
void SpawnParticles::StopTriggeredAction()
{
   m_VarParticles->SetDraw(false);
}
/******************************************************************************/